// By EVOLVED
// www.evolved-software.com

//--------------
// tweaks
//--------------  
   float2 ViewSize;
   float2 Aspect={1.0,1.0};
   float Offset=4.0;
   float2 DepthSize;

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
         Texture=<RenderTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };

//--------------
// structs 
//--------------
   struct InPut
      {
	 float4 Pos:POSITION;
      };
   struct OutPut
      {
	 float4 Pos:POSITION; 
	 float4 Tex:TEXCOORD0;
	 float4 Tex1:TEXCOORD1;
	 float4 Tex2:TEXCOORD2;
	 float4 Tex3:TEXCOORD3;
         float4 Tex4:TEXCOORD4;
      };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
      {
         OutPut OUT;
         OUT.Pos=IN.Pos; 
         OUT.Tex.xy=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize;
         OUT.Tex.zw=0.0;
         OUT.Tex1.xy=OUT.Tex+float2(ViewSize.x,0.0)*Offset*Aspect*1.2;
         OUT.Tex1.zw=OUT.Tex+float2(0.0,ViewSize.y)*Offset*Aspect*1.2;
         OUT.Tex2.xy=OUT.Tex-float2(ViewSize.x,0.0)*Offset*Aspect*1.2;
         OUT.Tex2.zw=OUT.Tex-float2(0.0,ViewSize.y)*Offset*Aspect*1.2;
         OUT.Tex3.xy=OUT.Tex+float2(ViewSize.x,ViewSize.y)*Offset*Aspect;
         OUT.Tex3.zw=OUT.Tex-float2(ViewSize.x,ViewSize.y)*Offset*Aspect;
         OUT.Tex4.xy=OUT.Tex+float2(-ViewSize.x,ViewSize.y)*Offset*Aspect;
         OUT.Tex4.zw=OUT.Tex+float2(ViewSize.x,-ViewSize.y)*Offset*Aspect;
         return OUT;
     }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
         float3 FrameRender=tex2Dlod(RenderSampler,IN.Tex).xyz*0.25
                           +tex2Dlod(RenderSampler,IN.Tex1.xyyy).xyz*0.125
                           +tex2Dlod(RenderSampler,IN.Tex1.zwww).xyz*0.125
                           +tex2Dlod(RenderSampler,IN.Tex2.xyyy).xyz*0.125
                           +tex2Dlod(RenderSampler,IN.Tex2.zwww).xyz*0.125
                           +tex2Dlod(RenderSampler,IN.Tex3.xyyy).xyz*0.0625
                           +tex2Dlod(RenderSampler,IN.Tex3.zwww).xyz*0.0625
                           +tex2Dlod(RenderSampler,IN.Tex4.xyyy).xyz*0.0625
                           +tex2Dlod(RenderSampler,IN.Tex4.zwww).xyz*0.0625;
         IN.Tex.xy=floor(IN.Tex.xy*DepthSize)/DepthSize;
         float2 DepthSize2=DepthSize*2.0;
         float Depth=0.0;
         for (int x = 0; x < 4; x++) {
          Depth=max(Depth,tex2Dlod(RenderSampler,IN.Tex+float4(x/DepthSize2.x,0.0,0.0,0.0)).w);
          Depth=max(Depth,tex2Dlod(RenderSampler,IN.Tex+float4(x/DepthSize2.x,1.0/DepthSize2.y,0.0,0.0)).w);
          Depth=max(Depth,tex2Dlod(RenderSampler,IN.Tex+float4(x/DepthSize2.x,2.0/DepthSize2.y,0.0,0.0)).w);
          Depth=max(Depth,tex2Dlod(RenderSampler,IN.Tex+float4(x/DepthSize2.x,3.0/DepthSize2.y,0.0,0.0)).w);
         }
         return float4(FrameRender,Depth);
     }

//--------------
// techniques   
//--------------
    technique Downfilter
      {
         pass p1
      {         
         VertexShader = compile vs_3_0 VS();
         PixelShader  = compile ps_3_0 PS();
         zwriteenable=false;
         zenable=false;
         zFunc=always;
      }
      }
